/* 6/4/18
 *  Archived Ebaylcd1
 *  This extension adds some analog inputs for adjusting contrast and display
 */


/* 11/11/15
 *  finally getting around to the Ebay LCD's on Arduino- want to use hardware SPI
 *  initial plan is to get basic functionality- perhaps a nice library, project will evolve.
 *  ressurected some old avr asm code for some basic structure- looking at public resources.
 */

/* Serial Mode P/S = L
 * HiPwr/Normal = L 
*  D0 to D5 are Open. They can be “H”, “L” or Open
*  RD (E) and WR (P/W) are L- they can be“H” or “L”.
*  RAM reading is not supported in serial mode
*  D6 is clock
*  D7 is data in
*/

// 11/1/18 fleshing out
// added bme280 stuff

//******************************************************
#include <SPI.h>
// equates for hw
#define resetPin 7    //debug- seems to be required- replace with RC?
#define slaveSelectPin 10
#define rsPin 9

//start of code
#define contpot 0     //right pot- contrast
#define inpot   1       //left pot- input volts


//globals
long int dval=0;        // 32 bit signed- +-2e9  scaled +-2.0001e5
char contr=0;           // adc value >> 4 for contrast
char numstr[11];             //storage for number conversion
char page=0;                 //global page
char col=0;                  //global column

// global store for font tables
//small font table 5x7 ascii order starting at 35d- punctuation, numbers and caps
const char font1[] PROGMEM = {
8,8,62,8,8,               //+ 43
0,0,80,48,0,              //' 44
8,8,8,8,8,                //- 45
0,96,96,0,0,              //. 46
32,16,8,4,2,              /// 47
62,81,73,69,62,           //0 48
0,66,127,64,0,            //1 49
66,97,81,73,70,           //2 50
34,65,73,73,54,           //3 51
24,20,18,127,16,          //4 52
39,69,69,69,57,           //5 53
62,73,73,73,50,           //6 54
97,17,9,5,3,              //7 55
54,73,73,73,54,           //8 56
38,73,73,73,62,           //9 57
0,54,54,0,0,              //: 58
0,58,86,54,0,             //; 59  
0,8,28,54,99,             //< 60
20,20,20,20,20,           //= 61
65,99,54,28,8,            //> 62
2,1,81,9,6,               //? 63
0,0,0,0,0,                //space- 64d
126,9,9,9,126,            //A 65
127,73,73,73,54,          //B 66
62,65,65,65,34,           //C 67
127,65,65,65,62,          //D 68
127,73,73,73,65,          //E 69
127,9,9,9,1,              //F 70
62,65,73,73,58,           //G 71
127,8,8,8,127,            //H 72
0,65,127,65,0,            //I 73
32,65,65,65,63,           //J 74
127,8,20,34,65,           //K 75
127,64,64,64,64,          //L 76
127,2,4,2,127,            //M 77
127,4,8,16,127,           //N 78
62,65,65,65,62,           //O 79
127,9,9,9,6,              //P 80
62,65,81,97,126,          //Q 81
127,9,25,41,70,           //R 82
6,73,73,73,48,            //S 83
1,1,127,1,1,              //T 84
63,64,64,64,63,           //U 85
31,32,64,32,31,           //V 86
127,32,16,32,127,         //W 87
99,20,8,20,99,            //X 88
3,4,120,4,3,              //Y 89
97,81,73,69,67,           //Z 90
};

//large font table  16 tall 8 wide- only numbers and signs/:
const char font2[] PROGMEM = {
0XC0,0XC0,0XC0,0XF8,0XF8,0XC0,0XC0,0XC0,   //+ 43
0X0 ,0X0 ,0X0 ,0X7 ,0X7 ,0X0 ,0X0 ,0X0 ,
0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,   //, 44
0X0 ,0X0 ,0X0 ,0X30,0X30,0X0 ,0X0 ,0X0 ,
0X0 ,0XC0,0XC0,0XC0,0XC0,0XC0,0XC0,0X0 ,   //- 45
0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,
0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,   //. 46
0X0 ,0X0 ,0X0 ,0X30,0X30,0X0 ,0X0 ,0X0 ,
0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,   //spc 47
0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,0X0 ,
0XF8,0XFE,0X7 ,0X3 ,0X3 ,0X7 ,0XFE,0XF8,   //0 48
0X7 ,0X1F,0X38,0X30,0X30,0X38,0X1F,0X7 ,    
0X0 ,0X0 ,0X0C,0XFE,0XFF,0X0 ,0X0 ,0X0 ,   //1 49
0X0 ,0X0 ,0X0 ,0X3F,0X3F,0X0 ,0X0 ,0X0 ,
0X4 ,0X6 ,0X3 ,0X3 ,0X3 ,0X83,0XFE,0X7C,   //2 50
0X30,0X38,0X3C,0X36,0X33,0X31,0X30,0X30,
0X4 ,0X6 ,0X3 ,0X3 ,0XC3,0XC3,0XFE,0X3C,   //3 51
0X18,0X18,0X30,0X30,0X30,0X31,0X1F,0X0F,
0XC0,0XE0,0XB0,0X98,0X8C,0XFE,0XFF,0X80,   //4 52
0X1 ,0X1 ,0X1 ,0X1 ,0X1 ,0X3F,0X3F,0X1 ,
0XFF,0XFF,0XC3,0XC3,0XC3,0XC3,0X83,0X3 ,   //5 53
0X18,0X18,0X30,0X30,0X30,0X38,0X1F,0X0F,
0XFC,0XFE,0XC7,0XC3,0XC3,0XC3,0X86,0X0 ,   //6 54
0X0F,0X1F,0X30,0X30,0X30,0X30,0X1F,0X0F,
0X0 ,0X3 ,0X3 ,0XC3,0XE3,0X33,0X1F,0X0F,   //7 55
0X0 ,0X0 ,0X0 ,0X3F,0X3F,0X0 ,0X0 ,0X0 ,
0X3C,0XFE,0XE3,0XE3,0XE3,0XE3,0XFE,0X3C,   //8 56
0X0F,0X1F,0X30,0X30,0X30,0X30,0X1F,0X0F,
0X3C,0X7E,0XC3,0XC3,0XC3,0XC3,0XFE,0X3C,   //9 57
0X8 ,0X18,0X30,0X30,0X30,0X30,0X1F,0X0F
};

//global store for strings in rom
//                               1234567890123456
const char Heading[] PROGMEM = {"  WEATHER DATA  "};

const char Temp[] PROGMEM = {"TEMP= "};
const char Press[] PROGMEM = {"PRES= "};
const char Humi[] PROGMEM = {"HUM = "};

//****************************************************************************************
void setup() {
  
 // hardware reset- this might be an RC in future 
 // appears to be required for reliable operation
  pinMode(resetPin,OUTPUT);
  digitalWrite(resetPin,LOW);
  delay(5);
  digitalWrite(resetPin,HIGH);
  
Serial.begin(9600);
  
Serial.println ("ok");
  // initialize SPI:
  
SPI.begin();

pinMode(rsPin, OUTPUT);               //A0- high is data, low is command
  pinMode (slaveSelectPin, OUTPUT);     // set the slaveSelectPin as an output:
  digitalWrite(slaveSelectPin, HIGH);  
//SPI.beginTransaction(SPISettings(1400000, MSBFIRST, SPI_MODE0));
  
  Serial.println ("init spi");
// port pins set and HW SPI initialized

//LCD initializtions
//make this a function

  // lcd commands for initialization
  tell(0XE2);     //soft reset
  tell(0xA3);     //1/7 65 duty
  tell(0xA6);     //normal/reverse= normal

//  //make display upside down- remember 28 pixel offset when setting left
//  tell(0xA0);     //adc select seg addresses- reverse
//  tell(0xC8);     //commons- reverse

    tell(0xA1);     //adc select seg addresses- this is normal for this display
    tell(0xC0);     //commons- reverse
  
    tell(0x23);     //r ratio- mid scale <coarse>
  
  tell(0x81);     //set "volume"
  tell(0x2D);     //lcd 6 bit contrast <fine>
  tell(0x2F);     //pwr control
  // basic initialization done

  tell(0XAF);     //turn on display
  
  tell(0x40);     //start displaying data on line 0
  setloc();       //page and col set to zero above
  
 Serial.println("LCD Initialized");

dspclr();
//dspall();
Serial.println("init");

//show a string template
  page=0; col=0; setloc();
  showstr(Heading);
  
  page=2; col=0; setloc();
  showstr(Temp);
 
  page=3; col=0; setloc();
  showstr(Press);
  
  page=4; col=0; setloc();
  showstr(Humi);
 }//end setup



// *** functions
void tell(char cmd)  {                //low level byte write for commansds
  digitalWrite(rsPin, LOW);           //command write
  digitalWrite(slaveSelectPin, HIGH);  //chip select
  SPI.transfer(cmd);
  digitalWrite(slaveSelectPin, LOW);  //chip select
} //end tell

void show(char data)  {  //low level byte write for data
  digitalWrite(rsPin, HIGH);               //data write
  digitalWrite(slaveSelectPin, HIGH);       //chip select
  SPI.transfer(data);
  digitalWrite(slaveSelectPin, LOW);  //chip select
  col+=1;
} //end show

//debug- show a string
 void showstr(unsigned int strst)
 {
  unsigned char i,j;
  i=0;
  j=1;
  while(j!=0) {
    j=pgm_read_byte_near((strst+ i));
    prfnt1(j);
     i++;
  }
 }
  

// small font display- single line x 5 chars
// the font size could be a parameter... to compact this code
void prfnt1(char val) {   //mid level function to print character from font table 1- current pos
  int pval;
   unsigned char i;
  pval=val;   //cast- pointer arithmetic expands
  if (pval == 32) pval=64;        //special case- space
  pval = 5*(pval- 43);             //calc offset
  for (i =pval ; i<pval+5 ; i++){
      show(pgm_read_byte_near((font1 + i)));
  }
  show (0); //intercharacter space
}//end prfnt1

// print using large font
//characters are 8 bits wide and 2 bytes tall and take page and page+1
//page is global scope- restore to original when done
void prfnt2(char val) {   //mid level function to print character from font table 2- current pos
  int pval;
  int i;
 
  pval=val;   //cast- pointer arithmetic expands
  if (pval == 32) pval=47;        //special case for space
  pval = 16*(pval- 43);             //calc offset
  for (i =pval ; i<pval+8 ; i++){
         show(pgm_read_byte_near((font2 + i)));
       
  }
  show(0); //intercharacter space
  page+=1;  col-=9;  setloc();  //reset for lower byte
  
    //restore pval
  pval=val;   //cast- pointer arithmetic expands
  if (pval == 32) pval=47;        //special case for space- offset 
  pval = 16*(pval- 43)+8;             //offset line 2
  for (i =pval ; i<pval+8 ; i++){
        show(pgm_read_byte_near((font2 + i)));
  }
    show(0); //intercharacter space
    page-=1; setloc();
    }
//end prfnt2

//this just writes all pixels to zero- there is a real dspclr?
void dspclr() {  //clear display
    unsigned char i;
    page=0; col=0; setloc();
  while(page<8){
    for (i = 0; i < 100; i++){
        show(0);
      }  //debug
    page++; col=0; setloc();
  }  
  page=0; col=0; setloc();
}//end dspclr

//displays all characters at top of screen
//debug only
void dspall() {
  unsigned char i,j          ;  //i is pixel column
j=43;     //character number
while(page<=4){
for(i=0;i<16;i++)
    {
     if((i+j)<91)prfnt1(i+j); 
    }
 j+=16;
 page+=1;col=0;setloc();
 }
}





//display longint dval using globals numstr and dval
//at current location
// add a parameter for large or small font?

void dispval(char m,char n,char s) {
  char i,j,l,sgn;           //m nums before dp
                           //n nums after dp
                           //s scaling factor
                           //sgn sign ascii
if (dval<0){ 
  dval = -dval ;
  sgn='-';} 
  else sgn='+';
if (dval==0)sgn=' ';  //sign stored as ascii
ltoa(dval,&numstr[0],10);   //convert long int to ascii    
l=strlen(numstr);                     //length including sign for pos or neg
//first segment- prespaces
j=m-1; i=(l-s)-2;
while (i<0 & j>0){
  prfnt1(' '); j--; i++;
}
prfnt1(sgn);  //-_+
//post sign
j++;
    while (j>0)
    {
        if(i>=0 & i<l) prfnt1(numstr[i]); 
        else prfnt1('0');
      j--;
      i++;
    }
prfnt1('.');
j+=n-1;
while (j>=0){
  if(i>=0 & i<l)prfnt1(numstr[i]);
    else prfnt1('0');
    j--;
    i++;
    }
    
}

void setloc() {   // no parameters- uses global page and col
   tell(page + 0xB0 ); 
   tell(0x10 + ((col & 0xF0)>>4));   //set column high
   tell(0x00 + (col & 0x0F));        //set column low
 }

//***************************** end of all setup and functions- loop begin ********************************
//*****************************************************************************************************

// routine- will eventually be a function or more likely a library
void loop(){
    char i,j,l,m,n,sgn,s;
// get contrast pot
contr=analogRead(contpot)>>4;
tell(0x81); tell(contr);     //lcd 6 bit contrast <fine>

dval = analogRead(inpot);    // read the input pin
Serial.println(dval,DEC);

page=2; col=35; setloc();  //display at temp
dispval(1,3,2);    //display value at current cursor 1023 disp 1.023

page=3; col=35; setloc();  //display at hum
dispval(4,1,3);    //display value at current cursor 1023 disp 1023.


dval=3219*(dval); 
page=4; col=35; setloc();
dispval(1,3,5);

//*************
// number printer funtion(m,n,s)
page=3; col=35; setloc();
dispval(1,3,5);    //display value at current cursor


//done printing small- now print large
// this old code that reproduces most of dispval
// should make bool parameter that displays large or small
page=6; col=0; setloc();
if (dval<0){ 
  dval = -dval ;
  sgn='-';} 
  else sgn='+';
if (dval==0)sgn=' ';  //sign stored as ascii
ltoa(dval,&numstr[0],10);   //convert long int to ascii    
l=strlen(numstr);                     //length including sign for pos or neg
//first segment- prespaces
m=1;
n=3;
s=5;

j=m-1; i=(l-s)-2;
while (i<0 & j>0){
  prfnt2(' '); j--; i++;
}
prfnt2(sgn);  //-_+

//post sign
j++;
    while (j>0)
    {
        if(i>=0 & i<l) prfnt2(numstr[i]); 
        else prfnt2('0');
      j--;
      i++;
    }
prfnt2('.');
j+=n-1;
while (j>=0){
  if(i>=0 & i<l)prfnt2(numstr[i]);
    else prfnt2('0');
    j--;
    i++;
    }

//delay and loop
delay(250);
Serial.println("Loop Bottom");
}


